/*
 * System log module.
 * Copyright(c) 2014 Shenzhen TP-LINK Technologies Co.Ltd.
 *
 * Author  : Ye Qianchuan <yeqianchuan@tp-link.net>
 * Detail  : System log daemon.
 * Version : 1.0
 * Date    : 3 Apr, 2014
 * Modify  : 3 Sep, 2014 By Mou Yuan <mouyuan@tp-link.net>
 */

#ifndef __LOG_LOGD_H__
#define __LOG_LOGD_H__

#include <inttypes.h>
#include <stdbool.h>

#define PERROR(s) perror("logd: " s)

#define _LOG_BUF_MAX_SIZE (512)
#define _LOG_MAX_NUM	  (512)
#define _LOG_PATH "/tmp/log"

#define LOGD_LOCK_FILE "/tmp/logd.pid"

#define debug(fmt, args...)\
	printf("[%s %d] "fmt"\n", __func__, __LINE__, ##args)

#endif  /* __LOG_LOGD_H__ */
